<?xml version="1.0" encoding="UTF-8"?>
<!-- 
<?xml:stylesheet href="../documentation.xsl" type="text/xsl"?> 
-->
<!--xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl"-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output method="xml" version="1.0" indent="yes"/>
	
	<xsl:variable name="none">[néant]</xsl:variable>

	<xsl:variable name="actorLabel">Acteurs</xsl:variable>
	<xsl:variable name="author">Auteur</xsl:variable>
	<xsl:variable name="date">Date</xsl:variable>
	<xsl:variable name="description">Description</xsl:variable>
	<xsl:variable name="history">Historique</xsl:variable>
	<xsl:variable name="idLabel">Id</xsl:variable>
	<xsl:variable name="label">Libéllé</xsl:variable>
	<xsl:variable name="note">Note</xsl:variable>
	<xsl:variable name="preconditionsLabel">Préconditions</xsl:variable>
	<xsl:variable name="priorityLabel">Priorité</xsl:variable>
	<xsl:variable name="project">Informations sur le projet</xsl:variable>
	<xsl:variable name="riskLabel">Risque</xsl:variable>
	<xsl:variable name="scenarioLabel">Scénario</xsl:variable>
	<xsl:variable name="screenshot">Capture d'écran</xsl:variable>
	<xsl:variable name="sequenceLabel">Séquence</xsl:variable>
	<xsl:variable name="url">Web</xsl:variable>
	<xsl:variable name="useCase">Cas d'utilisation</xsl:variable>
	<xsl:variable name="version">Version</xsl:variable>

	<xsl:template match="/">
		<xsl:apply-templates select="functional"/>
	</xsl:template>

	<xsl:template match="functional">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE article PUBLIC "-//OASIS//DTD DocBook XML V4.2//EN"
               "http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd"&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;?xmlspysps http://www.altova.com/sps/Template/Publishing/docbook.sps?&gt;</xsl:text>
		<article>
				<title>
					<xsl:value-of select="project/name"/> : Dossier de spécifications - cas d'utilisation
				</title>
				<section>
					<title>Table des matières</title>
					<orderedlist>
						<xsl:apply-templates select="function" mode="toc"/>
					</orderedlist>
				</section>
				<xsl:apply-templates select="project"/>
				<xsl:apply-templates select="function"/>
		</article>
	</xsl:template>

	<xsl:template match="project">
		<section> <!--sect2-->
			<title><xsl:value-of select="$project"/></title>
			<table>
				<title></title>
				<tgroup align='left' colsep='1' rowsep='1'>
					<thead>
						<row>
							<entry/>
							<entry><xsl:value-of select="$label"/></entry>
						</row>
					</thead>
					<tbody>
						<row>
							<entry><xsl:value-of select="$version"/></entry>
							<entry><xsl:value-of select="version"/></entry>
						</row>
						<row>
							<entry><xsl:value-of select="$url"/></entry>
							<entry><xsl:value-of select="location"/></entry>
						</row>
						<row>
							<entry><xsl:value-of select="$description"/></entry>
							<entry><xsl:apply-templates select="description/paragraph"/></entry>
						</row>
					</tbody>
				</tgroup>
			</table>
		</section> <!--sect2-->
	</xsl:template>

	<xsl:template match="function" mode="toc">
		<listitem>
			<xsl:value-of select="title"/>
			<orderedlist>
				<xsl:apply-templates select="useCase" mode="toc"/>
			</orderedlist>
		</listitem>
	</xsl:template>
	<xsl:template match="function">
		<section> <!--sect1-->
			<title><xsl:value-of select="title"/></title>
			<para><xsl:value-of select="$priorityLabel"/> : <xsl:call-template name="displayPriority"/></para>
			<xsl:apply-templates select="description"/>
			<xsl:apply-templates select="screenshot"/>
			<xsl:apply-templates select="history"/>
			<xsl:apply-templates select="note"/>
			<section> <!--sect2-->
				<title><xsl:value-of select="$useCase"/></title>
				<!--itemizedlist mark='opencircle'-->
					<xsl:apply-templates select="useCase"/>
				<!--/itemizedlist-->
			</section> <!--sect2-->
		</section> <!--sect1-->
	</xsl:template>

	<xsl:template name="displayPriority">
		<!--xsl:param name="priority" select="$none"/-->
		<xsl:value-of select="@priority"/>
		<!--mediaobject>
			<imageobject>
				<imagedata fileref="images/priority_{@priority}.png"/>
			</imageobject>
			<textobject><phrase><xsl:apply-templates select="@priority"/></phrase></textobject>
		  <caption/>
		</mediaobject-->
	</xsl:template>

	<xsl:template match="description">
		<xsl:call-template name="displayInformation"><xsl:with-param name="titleParam"><xsl:value-of select="$description"/></xsl:with-param></xsl:call-template>
	</xsl:template>

	<xsl:template match="function/note">
		<xsl:call-template name="displayInformation"><xsl:with-param name="titleParam"><xsl:value-of select="$note"/></xsl:with-param></xsl:call-template>
	</xsl:template>

	<xsl:template name="displayInformation">
		<xsl:param name="titleParam" select="$none"/>
		<section> <!--sect2-->
			<title><xsl:value-of select="$titleParam"/></title>
			<xsl:apply-templates select="paragraph"/>
			<xsl:if test="count(paragraph)=0"><para>.</para></xsl:if>
		</section> <!--sect2-->
	</xsl:template>

	<xsl:template match="paragraph">
		<para>
			<xsl:apply-templates />
		</para>
	</xsl:template>

	<xsl:template match="screenshot">
		<section> <!--sect2-->
			<title><xsl:value-of select="$screenshot"/></title>
			<mediaobject>
				<imageobject>
					<imagedata fileref="{location}"/>
				</imageobject>
				<textobject><phrase><xsl:apply-templates select="title"/></phrase></textobject>
			  <caption><xsl:apply-templates select="description"/></caption>
			</mediaobject>
		</section> <!--sect2-->
	</xsl:template>

	<xsl:template match="actor">
		<listitem><xsl:value-of select="."/></listitem>
	</xsl:template>

	<xsl:template match="creation | modification">
		<row>
			<entry><xsl:apply-templates select="date"/></entry>
			<entry><xsl:value-of select="@author"/></entry>
			<entry>
				<xsl:apply-templates select="description/paragraph"/>
				<xsl:if test="count(description/paragraph)=0 and name()='creation'">creation</xsl:if>
			</entry>
		</row>
	</xsl:template>

	<xsl:template match="history">
		<section> <!--sect2-->
			<title><xsl:value-of select="$history"/></title>
			<table>
				<title></title>
				<tgroup cols='3' align='left' colsep='1' rowsep='1'>
					<thead>
						<row>
							<entry><xsl:value-of select="$date"/></entry>
							<entry><xsl:value-of select="$author"/></entry>
							<entry><xsl:value-of select="$description"/></entry>
						</row>
					</thead>
					<tbody>
						<xsl:apply-templates select="creation"/>
						<xsl:apply-templates select="modification"/>
					</tbody>
				</tgroup>
			</table>
		</section> <!--sect2-->
	</xsl:template>

	<xsl:template name="displayActors">
			<section>
				<title><xsl:value-of select="$actorLabel"/></title>
				<itemizedlist mark='opencircle'><title/>
					<xsl:apply-templates select="actor"/>
				</itemizedlist>
			</section>
	</xsl:template>
	
	<xsl:template name="displayPreconditions">
			<section>
				<title><xsl:value-of select="$preconditionsLabel"/></title>
				<itemizedlist mark='opencircle'><title/>
					<xsl:apply-templates select="preconditions"/>
				</itemizedlist>
			</section>
	</xsl:template>

	<xsl:template match="preconditions">
		<listitem>
			<xsl:variable name="id" select="@id"/>
			<xsl:value-of select="$scenarioLabel"/>
			<xsl:text> : [ </xsl:text><xsl:value-of select="$id"/> ] 
			<xsl:for-each select="//scenario[/@id=$id]">
				 <xsl:value-of select="title"/>
			</xsl:for-each>
		</listitem>
	</xsl:template>
	
	<xsl:template match="useCase" mode="toc">
		<listitem>
			[<xsl:value-of select="@id"/>] <xsl:value-of select="title"/>
			<orderedlist>
				<xsl:apply-templates select="scenario" mode="toc"/>
			</orderedlist>
		</listitem>
	</xsl:template>
	<xsl:template match="useCase">
		<section>
			<title>[<xsl:value-of select="@id"/>] <xsl:value-of select="title"/></title>
			<xsl:apply-templates select="description"/>
			<xsl:apply-templates select="screenshot"/>
			<xsl:apply-templates select="history"/>
			<xsl:apply-templates select="note"/>
			<xsl:call-template name="displayActors"/>
			<xsl:call-template name="displayPreconditions"/>
			<section>
				<title><xsl:value-of select="$scenarioLabel"/></title>
				<table>
					<title><xsl:value-of select="$scenarioLabel"/></title>
					<tgroup align='left' colsep='1' rowsep='1'>
						<thead>
							<row>
								<entry><xsl:value-of select="$idLabel"/></entry>
								<entry><xsl:value-of select="$riskLabel"/></entry>
								<entry><xsl:value-of select="$priorityLabel"/></entry>
								<entry><xsl:value-of select="$label"/></entry>
							</row>
						</thead>
						<tbody>
							<xsl:apply-templates select="scenario"/>
						</tbody>
					</tgroup>
				</table>
			</section>
		</section>
	</xsl:template>

	<xsl:template match="scenario" mode="toc">
		<listitem>
			[<xsl:value-of select="@id"/>] <xsl:value-of select="title"/>
			<!--orderedlist>
				<xsl:apply-templates select="interaction"/>
			</orderedlist-->
		</listitem>
	</xsl:template>
	<xsl:template match="scenario">
		<row>
			<entry><xsl:value-of select="@id"/></entry>
			<entry><xsl:value-of select="@risk"/></entry>
			<entry><xsl:call-template name="displayPriority"/></entry>
			<entry><xsl:value-of select="title"/></entry>
		</row>
		<row>
			<entry/>
			<entry/>
			<entry/>
			<entry>
				<itemizedlist mark='opencircle'>
					<xsl:apply-templates select="interaction"/>
				</itemizedlist>
			</entry>
		</row>
	</xsl:template>

	<xsl:template match="interaction">
		<listitem><xsl:apply-templates /></listitem>
	</xsl:template>

	<xsl:template match="action">
		[action] <xsl:value-of select="@actionLabel"/>
	</xsl:template>

	<xsl:template match="reaction">
		[réaction] <xsl:value-of select="@reactionLabel"/>
	</xsl:template>

</xsl:stylesheet>
